using System;
using Server;
using Server.Items;
using System.Collections;
using System.Collections.Generic;
using Server.Mobiles;

namespace Server.Items
{
	
	[FlipableAttribute( 0x27A5, 0x27F0 )]
	public class Luk : BaseRanged
	{
		public override int ArtifactRarity{ get{ return 100; } }
		
		public override int EffectID{ get{ return 0xF42; } }
		public override Type AmmoType{ get{ return typeof( Arrow ); } }
		public override Item Ammo{ get{ return new Arrow(); } }
		
		public override WeaponAbility PrimaryAbility{ get{ return WeaponAbility.ArmorPierce; } }
		public override WeaponAbility SecondaryAbility{ get{ return WeaponAbility.DoubleShot; } }
		
		public override int AosStrengthReq{ get{ return 35; } }
		public override int AosMinDamage{ get{ return 18; } }
		public override int AosMaxDamage{ get{ return 25; } }
		public override int AosSpeed{ get{ return 32; } }
		
		public override int OldStrengthReq{ get{ return 35; } }
		public override int OldMinDamage{ get{ return 19; } }
		public override int OldMaxDamage{ get{ return 25; } }
		public override int OldSpeed{ get{ return 32; } }
		
		public override int DefMaxRange{ get{ return 10; } }
		
		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }
		
		public override WeaponAnimation DefAnimation{ get{ return WeaponAnimation.ShootBow; } }
		
		[Constructable]
		public Luk() : base( 0x27A5 )
		{
			Weight = 9.0;
			Name = "Luk";
			Hue = 1181;
			Layer = Layer.TwoHanded;
			LootType = LootType.Blessed;
			Balanced = true;
			Attributes.WeaponDamage = 20;
			Attributes.AttackChance = 22;
			Attributes.BonusMana = 20;
			Attributes.BonusDex = 15;
			Attributes.LowerManaCost = 20;
			Attributes.Luck = 150;
			Attributes.WeaponSpeed = 30;
			WeaponAttributes.HitLeechHits = 40;
			WeaponAttributes.HitLeechMana = 40;
			WeaponAttributes.HitLeechStam = 40;
			WeaponAttributes.HitLightning = 30;
			WeaponAttributes.HitFireball = 25;
			WeaponAttributes.HitHarm = 30;
			WeaponAttributes.BattleLust = 1;
			
			SkillBonuses.SetValues( 0, SkillName.Archery, 20.0 );
			SkillBonuses.SetValues( 1, SkillName.Tactics, 20.0 );
		}
		
		public override void GetDamageTypes(Mobile wielder, out int phys, out int fire, out int cold, out int pois, out int nrgy)
		{
			fire = cold = phys = pois = nrgy = 20;
		}
		
		public override void DoFireball(Mobile attacker, Mobile defender)
		{
			if ( !attacker.CanBeHarmful(defender, false) || !attacker.Player )
				return;

			attacker.MovingParticles(defender, 0x36D4, 7, 0, false, true, 9502, 4019, 0x160);
			attacker.PlaySound(0x15E);

			Aura( attacker, defender );
		}

		
		private void Aura( Mobile attacker, Mobile defender )
		{
			if ( attacker == null || attacker.Deleted || defender == null || defender.Deleted )
				return;
			
			ArrayList targets = new ArrayList();

			foreach (Mobile m in defender.GetMobilesInRange(2))
			{
				if ( m == null || m.Deleted || m == attacker || m == defender )
					continue;

				if (m is BaseCreature && !(((BaseCreature)m).Controlled || ((BaseCreature)m).Summoned))
				{
					if ( !m.IsDeadBondedPet && m.Alive && !m.Blessed && m.InLOS( defender ) )
						targets.Add(m);
				}
			}
			
			targets.Add( defender );

			for (int i = 0; i < targets.Count; ++i)
			{
				Mobile m = (Mobile)targets[i];
				
				if ( m == null || m.Deleted )
					continue;

				m.RevealingAction();
				
				//attacker.DoHarmful(m);

				//Effects.SendLocationParticles( EffectItem.Create( m.Location, Map, EffectItem.DefaultDuration ), 0x36BD, 20, 10, 5044 );
				//Effects.PlaySound( m.Location, Map, 520 );
				
				m.FixedParticles( 0x36BD, 20, 10, 5044, EffectLayer.Head );
				m.PlaySound( 0x307 );
				
				double damage = GetAosDamage(attacker, 30, 2, 10);
				Spells.SpellHelper.Damage(TimeSpan.FromSeconds(1.0), m, attacker, damage, 0, 100, 0, 0, 0);
				
				//AOS.Damage( m, attacker, Utility.Random( 150, 200 ), 0, 100, 0, 0, 0 );
			}
		}
		
		public Luk( Serial serial ) : base( serial )
		{
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=#33FF66>Fires Exploding Arrows<basefont color=White>" );
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}
		
		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
			
			if ( Weight == 7.0 )
				Weight = 9.0;
		}
	}
}
